from django.shortcuts import render
from django.http import StreamingHttpResponse
from .camera import VideoCamera

# Dicionário global para não abrir a mesma câmera várias vezes
cameras = {}

def video_feed(request, cam_id=0):
    global cameras
    cam_id = int(cam_id)
    
    if cam_id not in cameras:
        cameras[cam_id] = VideoCamera(index=cam_id)
    
    return StreamingHttpResponse(gen(cameras[cam_id]),
                                 content_type='multipart/x-mixed-replace; boundary=frame')

def gen(camera):
    while True:
        frame = camera.get_frame()
        if frame:
            yield (b'--frame\r\n'
                   b'Content-Type: image/jpeg\r\n\r\n' + frame + b'\r\n\r\n')
